<?php
if (!defined('_GNUBOARD_')) exit; //개별 페이지 접근 불가

// 옵션
$wos = apms_options($options, $m_options);
$list = apms_board_rows($wos);
$list_cnt = count($list);
if(!$list_cnt) {
	echo '<p class="text-muted text-center">글이 없습니다.</p>'.PHP_EOL;	
	return;
}

// 제목자르기
if(!$wos['cut']) $wos['cut'] = 25;
if(!$wos['icon']) $wos['icon'] = 'caret-right';
if(!$wos['new']) $wos['new'] = 'red';

?>

<ul class="widget-photo-list">
	<?php for ($i=0; $i < $list_cnt; $i++) {
		// 이미지가 없으면 사진으로 대체
		$list[$i]['img']['src'] = ($list[$i]['img']['src']) ? $list[$i]['img']['src'] : $list[$i]['photo'];
	?>
		<li>
			<a href="<?php echo $list[$i]['href'];?>">
				<?php if($list[$i]['img']['src']) { ?>
					<img src="<?php echo $list[$i]['img']['src'];?>" alt="<?php echo $list[$i]['img']['alt'];?>" class="img-thumbnail pull-left">
				<?php } else { ?>
					<b class="pull-left"><i class="fa fa-user fa-4x"></i></b>
				<?php } ?>
			</a>
			<p>
				<a href="<?php echo $list[$i]['href'];?>">
					<?php if($wos['rank']) { ?>
						<span class="en widget-rank-icon widget-rank-<?php echo $wos['rank'];?>"><?php echo $i+1;?></span>
					<?php } else if($list[$i]['new']) { ?>
						<i class="fa fa-<?php echo $wos['icon'];?><?php echo ($list[$i]['new']) ? ' '.$wos['new'] : '';?>"></i>
					<?php } ?>
					<?php echo apms_cut_text($list[$i]['subject'], $wos['cut']);?>
					<?php echo ($list[$i]['comment']) ? ' <small>'.$list[$i]['comment'].'</small>' : '';?>
					<?php echo ($list[$i]['secret']) ? ' <i class="fa fa-lock lightgray"></i>' : '';?>
				</a> 
				<span class="info">
					<i class="fa fa-user lightgray"></i> <?php echo $list[$i]['name'];?>
					&nbsp;
					<i class="fa fa-clock-o lightgray"></i> <?php echo apms_datetime($list[$i]['date'], 'm.d');?>
				</span>
			</p>
		</li>
	<?php } ?>
</ul>
